<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
[//lasso
	/*
	============================================================================
	Simple Web 2.0 with Lasso and jQuery - Controller
	============================================================================
	Author: Jason Huck/Core Five Creative
	Lasso Summit 2007
	----------------------------------------------------------------------------
	
	This is the main file from which any number of standalone modules could be
	loaded. You could take a lot of different approaches, but this was intended
	to show a) simplicity, and b) a way to keep the functionality of the modules
	self-contained, which is particularly useful when integrating them into an
	older project.
	
	Please note the following:
		- This demo expects "index.lasso" to be a default document in your web 
		  server configuration.
		  
		- This demo requires Lasso 8.5 or higher to function properly. This is 
		  purely due to laziness on my part!
		
		- To keep the complexity to a minimum, there is not much here in the way
	      of error reporting or graceful degradation. These things are most
	      definitely possible, they're just not present in this demo.
	*/

	/* Include required custom tags -- these would normally be loaded in startup,
	   on-demand, or some other more practical method. */
	var('ctags') = array(
		'xml_tree', 'rss', 'lp_header_nocache',
		'request_isajax', 'request_params',
		'yahoo_stockquote', 'yahoo_news',
		'weatherbug_getstations', 'weatherbug_getliveweather'	
	);	
	iterate($ctags, local('i'));
		library('lib/tags/' + #i + '.inc');
	/iterate;

	/* Ask the browser not to cache the page. */
	lp_header_nocache;

	/* Hand ajax requests off to the correct module. This aborts the rest of the
	  "normal" page and only returns the response to the ajax request. */
	request_isajax && action_param('mode') ? include('lib/modules/' + action_param('mode') + '.inc');
]
<html xmlns="http://www.w3.org/1999/xhtml" xml:lang="en" lang="en">
	<head>
		<meta http-equiv="content-type" content="text/html; charset=utf-8" />
		<title>Simple Web 2.0 with Lasso and jQuery</title>
		<link rel="stylesheet" type="text/css" href="lib/styles/global.css" />
[/*
	Include the main jquery library and a little plugin for making rounded
	corners.
*/]
		<script type="text/javascript" src="lib/scripts/jquery-latest.pack.js"></script>
		<script type="text/javascript" src="lib/scripts/jq-corner.js"></script>
	</head>
	<body>
		<h1>Simple Web 2.0 with Lasso and jQuery</h1>
[/*
	Including the modules here as non-ajax requests, they display their 
	"first-run" output.
*/]
		<div id="colCenter">
[include('lib/modules/headlinenews.inc')]
		</div>
		<div id="colRight">
[//lasso
	include('lib/modules/weather.inc');
	include('lib/modules/mysavedlinks.inc');
	include('lib/modules/mystocks.inc');
]
		</div>
		<h6 id="footer">Jason Huck/Core Five Creative | Lasso Summit 2007</h6>
	</body>
</html>
